'************************************
'PROJECT: Triple-mode Horse Race Game

'Bascom-Avr IDE [2.0.7.5]
'Micro: ATmega8A
'Flash used: 2944 Bytes
'By Mahmood Alimohammadi
'Date: 21 Feb. 2019
'************************************

$regfile = "m8adef.dat"
$crystal = 1000000

Config Lcdpin = Pin , Rs = Portb.0 , E = Portb.1 , Db4 = Portb.2 , Db5 = Portb.3 , Db6 = Portb.4 , Db7 = Portb.5
Config Lcd = 20 * 4

Config Timer0 = Timer , Prescale = 8

Config Portd.0 = Input : Portd.0 = 1 : Button Alias Pind.0
Config Portd.1 = Output : Piezo Alias Portd.1
Config Portd.2 = Input : Portd.2 = 1 : Modes Alias Pind.2
'-----------------------------------------------------
Dim Random1 As Word , Random2 As Word , ___rseed As Word , Step1 As Byte
Dim Step2 As Byte , Horse1 As Byte , Horse2 As Byte , Clean1 As Byte
Dim Clean2 As Byte , Del As Word , Speed As Byte
'-----------------------------------------------------

'Delay variable in milliseconds
Del = 210

'Variable for the speed of the two horses
Speed = 1

'*****************************************************
Begin:

Horse1 = 1
Horse2 = 1

Cls
Cursor Off

'Beep  for welcome address
Sound Piezo , 75 , 75

'Display picture 1 and 2 of the horses.
Gosub Picture1
Gosub Characters

Waitms 200

Gosub Picture2
Gosub Characters
'------------------------------
Locate 1 , 9
Lcd "Press"

Locate 2 , 9
Lcd "Button"


If Speed = 1 Then
Locate 3 , 9
Lcd "Mode: "
Locate 4 , 9
Lcd "Trot"
End If

If Speed = 2 Then
Locate 3 , 9
Lcd "Mode:"
Locate 4 , 9
Lcd "Canter"
End If

If Speed = 3 Then
Locate 3 , 9
Lcd "Mode:"
Locate 4 , 9
Lcd "Gallop"
End If

wait 1

'*****************************************************
Do

'Press Mode button for selecting the speed of the horses.
If Modes = 0 Then
   Speed = Speed + 1
   If Speed = 1 Then Del = 210
   If Speed = 2 Then Del = 140
   If Speed = 3 Then Del = 70
   If Speed > 3 Then
      Speed = 1
      Del = 210
   End If

   Goto Begin
End If

'Press the Play button to start the game.
If Button = 0 Then

   'Play button beep
   Sound Piezo , 200 , 100

   Exit Do
End If

Loop

'*****************************************************

'Main program
Do
'Assign ___RSEED with the Timer0 value.
 ___rseed = Timer0

'Get random number(0-7).
Random1 = Rnd(8)

'Convert the random numbers to 1 or 2 for the steps of Horse 1.
If Random1 > 3 Then Step1 = 1 Else Step1 = 2
Horse1 = Horse1 + Step1

If Horse1 > 17 Then Horse1 = 17

'Assign  __RSEED with the Timer0 value.
___rseed = Timer0

'Get random number (0-7).
Random2 = Rnd(8)

'Convert the random numbers to 1 or 2 for the steps of Horse 2.
If Random2 > 3 Then Step2 = 1 Else Step2 = 2
Horse2 = Horse2 + Step2

If Horse2 > 17 Then Horse2 = 17
'------------------------------

'Simulate the sound of the footsteps of the horses,segment 1 of 3
Sound Piezo , 30 , 15
Waitms Del

'Picture 1 of the horse
Gosub Picture1
Gosub Characters
Gosub Results

'Simulate the sound  of the footsteps of the horses,segment 2 of 3
Sound Piezo , 15 , 30
Waitms Del

'Picture 2 of the horse
Gosub Picture2
Gosub Characters
Gosub Results

'Simulate the sound  of the footsteps of the horses,segment 3 of 3
Sound Piezo , 20 , 40
Waitms Del

Loop
End

'*****************************************************

Characters:
Cls
Clean1 = Horse1 - 1

Clean2 = Horse2 - 1

'Clear the display as the horses move forward.
Locate 1 , Clean1 : Lcd " "
Locate 2 , Clean1 : Lcd " "

Locate 3 , Clean2 : Lcd " "
Locate 4 , Clean2 : Lcd " "


'Horse 1: 7 characters forming the picture of the horse
Locate 1 , Horse1
Lcd Chr(0) ; Chr(1) ; Chr(2) ; Chr(3)

Locate 2 , Horse1
Lcd Chr(4) ; Chr(5) ; Chr(6) ; Chr(7)

'Horse 2 : 7 characters forming the picture of the horse
Locate 3 , Horse2
Lcd Chr(0) ; Chr(1) ; Chr(2) ; Chr(3)

Locate 4 , Horse2
Lcd Chr(4) ; Chr(5) ; Chr(6) ; Chr(7)
Return
'-----------------------------------------------------
Results:

'Display the results for Horse 1.
If Horse1 > 16 And Horse2 < 17 Then
   'Adjusting the steps for 20 blocks of the LCD
   Horse1 = Horse1 + 3
   Horse2 = Horse2 + 3

   Sound Piezo , 100 , 200
   Wait 1
   Cls
   Locate 1 , 3
   Lcd "Winner:"

   Locate 2 , 4
   Lcd "Horse 1"

   Locate 3 , 6
   Lcd "Horse 1: " ; Horse1

   Locate 4 , 6
   Lcd "Horse 2: " ; Horse2
   Wait 2
   Goto Begin
End If

'-------------------------------
'Display the results for Horse 2.
If Horse2 > 16 And Horse1 < 17 Then

   'Adjust the steps for 20 blocks of the LCD.
   Horse1 = Horse1 + 3
   Horse2 = Horse2 + 3

   Sound Piezo , 200 , 100
   Wait 1
   Cls
   Locate 1 , 3
   Lcd "Winner:"

   Locate 2 , 4
   Lcd "Horse 2"

   Locate 3 , 6
   Lcd "Horse 2: " ; Horse2

   Locate 4 , 6
   Lcd "Horse 1: " ; Horse1
   Wait 2
   Goto Begin
End If
'------------------------------
'Display the results for both Horse 1 and Horse 2.
If Horse1 > 16 And Horse2 > 16 Then

   'Adjust the steps for 20 blocks of the LCD.
   Horse1 = Horse1 + 3
   Horse2 = Horse2 + 3

   Sound Piezo , 200 , 200
   Wait 1
   Cls
   Locate 1 , 5
   Lcd "Winners:"

   Locate 2 , 1
   Lcd "Horse1 & Horse2"

   Locate 3 , 6
   Lcd "Horse 1: " ; Horse1

   Locate 4 , 6
   Lcd "Horse 2: " ; Horse2
   Wait 2
   Goto Begin
End If

Return
'-----------------------------------------------------
Picture1:

Deflcdchar 0 , 32 , 32 , 32 , 32 , 32 , 7 , 14 , 28
Deflcdchar 1 , 32 , 32 , 32 , 32 , 15 , 31 , 31 , 31
Deflcdchar 2 , 2 , 12 , 30 , 25 , 31 , 31 , 31 , 31
Deflcdchar 3 , 32 , 1 , 31 , 31 , 31 , 27 , 19 , 16

Deflcdchar 4 , 12 , 24 , 16 , 1 , 1 , 1 , 32 , 32
Deflcdchar 5 , 31 , 31 , 30 , 19 , 1 , 32 , 16 , 32
Deflcdchar 6 , 31 , 31 , 3 , 2 , 2 , 2 , 17 , 32
Deflcdchar 7 , 28 , 28 , 4 , 4 , 8 , 32 , 32 , 32
Return
'-----------------------------------------------------
Picture2:

Deflcdchar 0 , 32 , 32 , 32 , 15 , 31 , 28 , 24 , 24
Deflcdchar 1 , 32 , 32 , 32 , 15 , 31 , 31 , 31 , 31
Deflcdchar 2 , 2 , 12 , 28 , 26 , 31 , 31 , 31 , 31
Deflcdchar 3 , 1 , 31 , 31 , 31 , 27 , 27 , 16 , 16

Deflcdchar 4 , 19 , 19 , 2 , 2 , 4 , 32 , 32 , 32
Deflcdchar 5 , 31 , 7 , 14 , 6 , 1 , 32 , 32 , 32
Deflcdchar 6 , 15 , 7 , 19 , 15 , 32 , 16 , 32 , 32
Deflcdchar 7 , 16 , 24 , 12 , 4 , 2 , 1 , 32 , 32
Return
'-----------------------------------------------------
'End of Program